function ColorObject()
{
	this.white = CreateColor(255, 255, 255);
	this.trans = CreateColor(255, 255, 255, 128);
	this.grey = CreateColor(128, 128, 128);
	this.black = CreateColor(0, 0, 0);
	this.red = CreateColor(255, 0, 0);
	this.green = CreateColor(0, 255, 0);
	this.blue = CreateColor(0, 0, 255);
	this.shadow = CreateColor(0, 0, 0, 128);
	this.blank = CreateColor(0, 0, 0, 0);
	// Special colors
	this.hp = CreateColor(101, 199, 176);
	this.mp = CreateColor(218, 167, 246);
	this.weak = CreateColor(231, 231, 0);
	this.empty = CreateColor(189, 0, 0);
}

var colors = new ColorObject();

function darken(color, percent)
{
	return BlendColorsWeighted(color, colors.black, 100 - percent, percent);
}

function GradientLineV(x, y, h, color1, color2)
{
	GradientLine(x, y, x, y + h - 1, color1, color2);
}

function GradientLineH(x, y, w, color1, color2)
{
	GradientLine(x, y, x + w - 1, y, color1, color2);
}

function gauge(x, y, w, min, max, color)
{
	GradientRectangle(x, y, w, 2, darken(color, 30), color, darken(color, 50), darken(color, 80));
	var incr = Math.floor(min * w / max);
	if (incr != w)
	{
		Rectangle(x + w - 1 - (w - incr - 1), y, w - incr, 2, colors.black);
	}
}

function drawCursor(x, y, trans)
{
	if (trans == undefined)
	{
		images.cursor.blit(x - images.cursor.width - 2, y);
	}
	else if (trans == true)
	{
		images.cursor.blitMask(x - images.cursor.width - 2, y, colors.trans);
	}
}

// Load up icons
images.icons = new Array();
images.icons["potion"] = LoadImage("icon_potion.png");